﻿import csv
import viz
import vizfx
import vizconnect
import vizact
import makingCSVFile
import zspace
import vizshape
import vizcam
import vizinfo
from tools import collision_test


class ExplosiveModel(viz.VizNode):
	""" creates a model with a given dae file and gets parts and moves them on specified axes """

	def __init__(self, rowData):
		
		self.isu = vizfx.addChild('RC_MET_ISU.dae')
		viz.VizNode.__init__(self, self.isu.id)
		self.scale = .035125 #this scale is determined by doc (dividing model size by .035, we get desired size)
		self.isu.setScale([self.scale]*30)
		self.current = 0 #index of current
		self.rowData = rowData[:]
		self.layerParents = []
		self.partDict = {}
		for tool in vizconnect.getToolsWithMode('Grabber'):
			tool.getRaw().setCollisionTester(collision_test.Distance(node=tool.getRaw(), distanceThreshold=1000))


	def getNextPart(self):
		""" returns the axis, distance away, and parts names of the next step """
		self.current = min(len(self.rowData)-1, self.current+1)
		print "get part", self.rowData[self.current][0], self.rowData[self.current][1]
		return self.rowData[self.current][0], self.rowData[self.current][1], self.rowData[self.current][2]

	def reset(self):
		for part in self.partDict.values():
			part.setParent(self)
			part.setMatrix(part.originalMatrix, viz.ABS_GLOBAL)
		for layerParent in self.layerParents:
			for tool in vizconnect.getToolsWithMode('Grabber'):
				tool.getRaw().removeItems([layerParent])
			layerParent.remove()
		self.layerParents = []
		self.current = 0

	def returnPreviousPartLayer(self):
		if self.current < 0:
			return
		try:
			currentNames = self.rowData[self.current][2]
			for childName in currentNames:
				part = self.partDict[childName]
				part.setParent(self)
				part.setMatrix(part.originalMatrix, viz.ABS_GLOBAL)
			self.current = max(0, self.current-1)
			# remove the layer parent
			layerParent = self.layerParents.pop(-1)
			for tool in vizconnect.getToolsWithMode('Grabber'):
				tool.getRaw().removeItems([layerParent])
			layerParent.remove()
		except KeyError:
			pass

	def movePart(self, part, vector, distance):
		""" moves a part along a unit vector to a given distance."""
		mat = vizmat.Transform()
		#model orientation determines expansion direction
		mat.setQuat(self.getQuat(viz.ABS_GLOBAL))
		#model scale still scales distance uniformly and ignoring initial scale
		mat.setScale([self.getScale(viz.ABS_GLOBAL)[0]/0.035125]*3)
		vector = vector * float(distance)
		vector = mat.preMultVec(vector)
		#component wise subtract the unit vector from one to
		#determine which portions of the position we use. We don't
		#just add to position, as all of the pieces are meant to go
		#to the same distance along the given unit vector.
		pos = part.getPosition(viz.ABS_GLOBAL)
		vector += [
			(1.0 - vector[0])*pos[0],
			(1.0 - vector[1])*pos[1],
			(1.0 - vector[2])*pos[2],
		]
		part.setPosition(vector, viz.ABS_GLOBAL)

	def moveNextPartLayer(self):
		""" based on the axis of movement, next parts are moved along the distance specified """
		try:
			axis, nextDistance, nextNames  = self.getNextPart()

			print "next Names", nextNames
			print "ax", axis
			print nextNames, int(nextDistance)
			#move next part nextName to distance nextDistance away from the object
			print nextNames[0]
			#set next layer
			layerParent = viz.addGroup()
			for partName in nextNames:
				if partName in self.partDict:
					part = self.partDict[partName]
				else:
					part = self.isu.getChild(partName)
					part.originalMatrix = part.getMatrix(viz.ABS_GLOBAL)
					self.partDict[partName] = part
				if axis == 'x':
					vector = vizmat.Vector([1, 0, 0])
				elif axis == 'y':
					vector = vizmat.Vector([0, 1, 0])
				elif axis == 'z':
					vector = vizmat.Vector([0, 0, 1])
				self.movePart(part, vector, float(nextDistance))
				#reparent the part to the layer
				mat = part.getMatrix(viz.ABS_GLOBAL)
				part.setParent(layerParent)
				part.setMatrix(mat, viz.ABS_GLOBAL)
			self.layerParents.append(layerParent)
			#add items to the grabber
			for tool in vizconnect.getToolsWithMode('Grabber'):
				tool.getRaw().addItems([layerParent])
		except IndexError:
			pass

def initZSpace():
	import zspace

	viz.setMultiSample(8)
	viz.clearcolor(viz.SLATE)

	#initialize zSpace display
	display = zspace.init()

	#Scale up the zSpace display to avoid having to
	#scale down all the models to fit within the display viewport
	display.setScale(200)

	#save handle to wand tracker
	wandTracker = zspace.getWandTracker()
	wandTracker.setLedEnabled(True)
	

#You could initialize the zspace using the code in the function initZSpace()
#since we're using grabbing, though, we'll use a vizconnect configuration
vizconnect.go('zspace_config.py') #zspace vizconnect setup
#viz.go()
#vizconnect.go('zspace_config1.py')
#alternatively, you could use the desktop                               
#vizconnect.go('vizconnect_desktop.py') #desktop vizconnect setup

rowData = []
#read csv data for part numbers per step
with open('names.csv', 'rb') as csvfile:
	reader = csv.reader(csvfile)
	for row in reader:
		rowData.append([row[0], row[1], row[2].split()])
print rowData

#gotoRight = vizact.goto([2,1,-2],rotate_mode=viz.BLEND_ROTATE,pivot=[0,2,0],ori_mask=viz.BODY_ORI)
#gotoLeft = vizact.goto([-2,2,-2],rotate_mode=viz.BLEND_ROTATE,pivot=[0,2,0],ori_mask=viz.BODY_ORI)
#spinAction = vizact.spinto(0,1,0,180,30,ori_mask=viz.BODY_ORI)


#info = vizinfo.InfoPanel(align=viz.ALIGN_RIGHT_TOP)

# Create info panel for rotate mode
#modePanel = vizinfo.InfoPanel('', title='Rotate Mode', align=viz.ALIGN_LEFT_TOP, icon=False)
#none = modePanel.addLabelItem('None',viz.addRadioButton('RotateMode'))
#pivot = modePanel.addLabelItem('Pivot',viz.addRadioButton('RotateMode'))
#blend = modePanel.addLabelItem('Blend',viz.addRadioButton('RotateMode'))
#none.set(True)

#Set the animation speed and mode
SPEED = 12
MODE = viz.SPEED
ROTATE_MODE = viz.PIVOT_ROTATE

#def SetRotateMode(mode):
#	global ROTATE_MODE
#	ROTATE_MODE = mode

#viewpoint = viz.addGroup()
#myview = vizconnect.CaveView(viewpoint)

def AnimateView(pos):
	action = vizact.goto(pos,SPEED,MODE,pivot=vizconnect.getViewpointDict(),rotate_mode=ROTATE_MODE)
	vizconnect.getTransport().getNode3d().runAction(action)

model = ExplosiveModel(rowData)
model.setScale([0.056]*3)
vizact.onkeydown(' ', model.moveNextPartLayer) #on spacebar keypress, a layer explodes
vizact.onkeydown(viz.KEY_CONTROL_L, model.returnPreviousPartLayer)

viz.clearcolor(viz.GRAY) #change background color if desired

#vizact.onkeydown('a', viz.MainView.runAction, gotoLeft) 
#vizact.onkeydown('d', viz.MainView.runActio444555n, gotoRight)
#vizact.onkeydown(viz.KEY_LEFT, caveView.runAction, spinAction)

#Setup keyboard events
vizact.onkeydown('1',AnimateView,[0,0,10])
vizact.onkeydown('A',AnimateView,[0,0,10])
vizact.onkeydown('D',AnimateView,[0,0,10])
vizact.onkeydown('W',AnimateView,[0,0,10])
vizact.onkeydown('S',AnimateView,[0,0,10])

vizact.onkeydown('r', model.reset)

#Setup button click events
#vizact.onbuttondown(none,SetRotateMode,viz.NO_ROTATE)		#The viewpoint will not rotate while it's  moving
#vizact.onbuttondown(pivot,SetRotateMode,viz.PIVOT_ROTATE)	#The viewpoint will look at the pivot point while it's moving
#vizact.onbuttondown(blend,SetRotateMode,viz.BLEND_ROTATE)	#The viewpoint will blend to looking at the pivot point

#Start off by moving to the first location
AnimateView([0,0,10])  